{
	Init[ ()
	{
		if( GetID() = "myclock" )
		{
			if( Level.debug_spew = 1 )
			{
				Delay(0,1);
			}
		}
	}]

	DelayReached[ (dy)
	{
		if( dy=1 )
		{
			if( Level.clock < 60 )
			{
				Level.Spew(" ");
				Level.clock = toInt( Level.clock + 1 );
				Level.Spew(" Clock:  " # Level.clock );
				Delay(1,1);
			}
			return;
		}

		Level.Spew(" ");
		Level.Spew("<<<< Sounds Delay >>>>");

		/////////////////////////////////////////
		//
		// Water Mortars
		//
		/////////////////////////////////////////

		if( dy=10 )
		{
			Level.Spew("   10 - H20 Morter");
			WaterMortar(100,128);
			WaterPlume(614,9728);
			Delay(8,11); // clock:  12 seconds
			return;
		}
		if( dy=11 )
		{
			Level.Spew("   11 - H20 Morter");
			WaterMortar(100,256);
			WaterPlume(1395,3776);
			Delay(12,12); // clock:  24 seconds
			return;
		}
		if( dy=12 )
		{
			Level.Spew("   12 - H20 Morter");
			WaterMortar(100,200);
			WaterPlume(1713,8200);
			Level.Spew("        --> Delay(13)");
			Delay(1,13); // clock:  25 seconds
			return;
		}
		if( dy=13 )
		{
			Level.Spew("   13 - H20 Morter");
			WaterMortar(100,200);
			WaterPlume(1188,6808);
			Delay(13,14); // clock:  38
			return;
		}
		if( dy=14 )
		{
			Level.Spew("   13 - H20 Morter");
			WaterMortar(100,200);
			WaterPlume(2555,6284);
			Delay(1,15); // clock 39
			return;
		}
		if( dy=15 )
		{
			Level.Spew("   13 - H20 Morter");
			WaterMortar(100,200);
			WaterPlume(2944,7539);
			return;
		}

		/////////////////////////////////////////
		//
		// Air attacks
		//
		/////////////////////////////////////////

		if( dy=20 )
		{
			Level.Spew("   20 - Flyby_1");
			FlyBy(1,20);
			Delay(17,21); // clock:  19
			return;
		}
		if( dy=21 )
		{
			Level.Spew("   21 - Flyby_2");
			FlyBy(2,60);
			Level.Spew("         --> Delay(22)");
			Delay(2,22); // clock:  21
			return;
		}
		if( dy=22 )
		{
			Level.Spew("   22 - Flyby_1");
			FlyBy(1,40);

			Level.Spew("        --> Delay(12)");
			Delay(13,23); // clock:  34
			return;
		}
		if( dy=23 )
		{
			Level.Spew("   23 - Flyby_1");
			FlyBy(2,100);
			GoPlane(1,500,2944,2600,4500,11136,2600,25000);
			Delay(2,24); // clock:  36
			return;
		}
		if( dy=24 )
		{
			Level.Spew("   24 - Flyby_2");
			FlyBy(1,100);
			GoPlane(2,500,2944,2600,4500,11136,2600,25000);
			return;
		}

		/////////////////////////////////////////
		//
		// Misc. Sounds
		//
		/////////////////////////////////////////

		if( dy=30 )
		{
			Level.Spew("   30 - Boat Explode");
			Level.GetPlayer().PlaySound(159,100,0); // Boat Explosion
			Level.GetPlayer().ScreenShake(256);
			return;
		}
		if( dy=50 )
		{
			Level.Spew("   50 - Look Out!");
			PlayerHears(160, 100); // Look Out!
			return;
		}
		if( dy=51 )
		{
			PlayerHears(41,100);
			PlayerHears(43,100);
			PlayerHears(42,100);
			Delay(1,54);
			return;
		}
		if( dy=52 )
		{
			PlayerHears(42,100);
			PlayerHears(41,100);
			PlayerHears(43,100);
			Delay(1,53);
			return;
		}
		if( dy=53 )
		{
			PlayerHears(41,100);
			PlayerHears(43,100);
			PlayerHears(42,100);
			return;
		}
		if( dy=54 )
		{
			PlayerHears(41,100);
			PlayerHears(43,100);
			return;
		}

		/////////////////////////////////////////
		//
		// Plane Billboards
		//
		/////////////////////////////////////////

		if( dy=70 )
		{
			GoPlane(1,2500,2944,2600,500,11136,2600,27000);
			Delay(18,71); // clock:  20
			return;
		}
		if( dy=71 )
		{
			GoPlane(2,500,11136,2600,2500,2944,2600,20000);
			Delay(2,72); // clock 22
			return;
		}
		if( dy=72 )
		{
			GoPlane(1,500,11136,2600,2500,2944,2600,25000);
		}
	}]

	PlayerHears[ (sound, volume)
	{
		Level.Spew("        PlaySound(" # sound # ")");
		player = Level.GetPlayer();
		player.PlaySound(sound,volume,0);
	}]

	WaterMortar[ (volume,shake)
	{
		player = Level.GetPlayer();
		player.PlaySound(161, volume, 0);
		player.ScreenShake( shake );
	}]

	WaterPlume[ (xPos,yPos)
	{
		PlaySound(3,6,true);
		Level.CreateEffect(260,266,1,xPos,yPos,0,128,14,72,72);
	}]

	FlyBy[ (which, volume)
	{
		player = Level.GetPlayer();
		if( which=1 )
		{
			player.PlaySound(162,volume,0);
		}else{
			player.PlaySound(163,volume,0);
		}
	}]

	GoPlane[ (which,x1,y1,z1,x2,y2,z2,speed)
	{
		if( which=1 ){ p = Level.GetEntity("plane1"); }
		if( which=2 ){ p = Level.GetEntity("plane2"); }

		p.ShowEntity( true );
		p.UseGravity(0);
		p.SetPosition(x1,y1,z1);
		p.SetSpeed(speed);
		p.WalkTo(x2,y2,0);
	}]
}